/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: HostStateDlg.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 4.07.06 16:23 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Host State Get/Set Test dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        04.07.2006  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file HostStateDlg.h
///   Host State Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"
#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////////////////
/// Host State Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CHostStateDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CHostStateDlg)

public:
	CHostStateDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CHostStateDlg();

// Dialog Data
	enum { IDD = IDD_HOSTSTATE };

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  uint32_t    m_ulSetTimeout;   //!< Timeout when calling Set Host State
  CComboBox   m_cNewStateCtrl;  //!< Set Host State Combobox Control

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();
};
